/*
  Qtechknow Creator Kit: Circuit 4 - ServoMotor
  
  Moves the gear on the Servo motor back and forth, in
  a sweeping motion.
 
  This example code is in the public domain -
  
  made by BARRAGAN
  modified by Scott Fitzgerald
*/

#include <Servo.h> // include Servo library
 
Servo myservo;  // create servo object to control Servo
 
int pos = 0;    // variable to store the servo position 
 
void setup() {
  
  myservo.attach(9);  // the servo is on pin D9

} 
 
void loop() {
  
  for(pos = 0; pos <= 180; pos += 1) // 0 -> 180 degrees 
  {                              // in steps of 1 degree 
    myservo.write(pos);          
    delay(15);    // waits for servo to reach the position 
  } 
  
  for(pos = 180; pos >= 0; pos -= 1) // 180 -> 0 degrees 
  {                              // in steps of 1 degree 
    myservo.write(pos);          
    delay(15);    // waits for servo to reach the position 
  } 
}
